# DX_CC6_CORE_HOST_SIDE makefile
# WMDRM_TST component
#

COMP_NAME := $(WMDRM_TST_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(SHARED_ATP_ID) $(WMDRM_ID) $(VOS_ID) $(CC6_GEN_ID) $(CRYS_ID) $(SST_ID) $(KMNG_ID)

#id's of the components whose objects are used by this component
$(COMP_NAME)_USE_OBJ_IDS := $(SHARED_ATP_ID) 

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)WMDRM/Test/blackbox/ \
	$(HOST_PATH)WMDRM/Test/devicestore/ \
	$(HOST_PATH)WMDRM/Test/drmmanager/ \
	$(HOST_PATH)WMDRM/Test/DX/inc/blackbox/ \
	$(HOST_PATH)WMDRM/Test/DX/inc/drmmanager/ \
	$(HOST_PATH)WMDRM/Test/DX/inc/testdevicestore/ \
	$(HOST_PATH)WMDRM/Test/DX/inc/ \
	$(HOST_PATH)WMDRM/Test/expreval/ \
	$(HOST_PATH)WMDRM/Test/inc/ \
	$(HOST_PATH)WMDRM/Test/liceval/ \
	$(HOST_PATH)WMDRM/Test/reftclib/ \
	$(HOST_PATH)WMDRM/Test/tstutils/licgen

#global flags for this component will be added here
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	binding blackboxtest CryptoTest dcParser \
	ddctest testdevicestore dlrb testdrmmanager \
	ExprEval testhds header \
	LicEval licpsr testlicstore metering \
	apiParams testsecstore \
	secclock testsynclist dOEMImp tOEMImp \
	tGetClientID SetClientID tLicGen tResponseGen \
	stubcert tstutils drmutiltest ViewRights \
	testxmlbuilder testXMLParser logger testrunner wmdrm_tst_menu

$(COMP_NAME)_MAIN_OBJ_NAMES := \
	wmdrm_tst_main

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)binding.$(OBJEXT): $(HOST_PATH)WMDRM/Test/blackbox/binding.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)blackboxtest.$(OBJEXT): $(HOST_PATH)WMDRM/Test/blackbox/blackboxtest.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CryptoTest.$(OBJEXT): $(HOST_PATH)WMDRM/Test/crypto/CryptoTest.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dcParser.$(OBJEXT): $(HOST_PATH)WMDRM/Test/devcertparser/dcParser.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ddctest.$(OBJEXT): $(HOST_PATH)WMDRM/Test/devicedevcert/ddctest.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testdevicestore.$(OBJEXT): $(HOST_PATH)WMDRM/Test/devicestore/testdevicestore.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dlrb.$(OBJEXT): $(HOST_PATH)WMDRM/Test/drmmanager/dlrb.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testdrmmanager.$(OBJEXT): $(HOST_PATH)WMDRM/Test/drmmanager/testdrmmanager.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testrunner.$(OBJEXT): $(HOST_PATH)WMDRM/Test/DX/src/testrunner.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)wmdrm_tst_menu.$(OBJEXT): $(HOST_PATH)WMDRM/Test/DX/src/wmdrm_tst_menu.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)wmdrm_tst_main.$(OBJEXT): $(HOST_PATH)WMDRM/Test/DX/src/wmdrm_tst_main.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ExprEval.$(OBJEXT): $(HOST_PATH)WMDRM/Test/expreval/ExprEval.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testhds.$(OBJEXT): $(HOST_PATH)WMDRM/Test/hds/testhds.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)header.$(OBJEXT): $(HOST_PATH)WMDRM/Test/header/header.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LicEval.$(OBJEXT): $(HOST_PATH)WMDRM/Test/liceval/LicEval.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)licpsr.$(OBJEXT): $(HOST_PATH)WMDRM/Test/licparser/licpsr.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testlicstore.$(OBJEXT): $(HOST_PATH)WMDRM/Test/licstore/testlicstore.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)metering.$(OBJEXT): $(HOST_PATH)WMDRM/Test/metering/metering.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)apiParams.$(OBJEXT): $(HOST_PATH)WMDRM/Test/reftclib/apiParams.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)logger.$(OBJEXT): $(HOST_PATH)WMDRM/Test/reftclib/logger.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testsecstore.$(OBJEXT): $(HOST_PATH)WMDRM/Test/secstore/testsecstore.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)secclock.$(OBJEXT): $(HOST_PATH)WMDRM/Test/secureclock/secclock.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testsynclist.$(OBJEXT): $(HOST_PATH)WMDRM/Test/synclist/testsynclist.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dOEMImp.$(OBJEXT): $(HOST_PATH)WMDRM/Test/toemimp/dOEMImp.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tOEMImp.$(OBJEXT): $(HOST_PATH)WMDRM/Test/toemimp/tOEMImp.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tGetClientID.$(OBJEXT): $(HOST_PATH)WMDRM/Test/tstutils/getclientid/tGetClientID.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)SetClientID.$(OBJEXT): $(HOST_PATH)WMDRM/Test/tstutils/licgen/SetClientID.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tLicGen.$(OBJEXT): $(HOST_PATH)WMDRM/Test/tstutils/licgen/tLicGen.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tResponseGen.$(OBJEXT): $(HOST_PATH)WMDRM/Test/tstutils/licgen/tResponseGen.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)stubcert.$(OBJEXT): $(HOST_PATH)WMDRM/Test/tstutils/utils/stubcert.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tstutils.$(OBJEXT): $(HOST_PATH)WMDRM/Test/tstutils/utils/tstutils.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmutiltest.$(OBJEXT): $(HOST_PATH)WMDRM/Test/utils/drmutiltest.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ViewRights.$(OBJEXT): $(HOST_PATH)WMDRM/Test/viewrights/ViewRights.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testxmlbuilder.$(OBJEXT): $(HOST_PATH)WMDRM/Test/xmlbuilder/testxmlbuilder.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)testXMLParser.$(OBJEXT): $(HOST_PATH)WMDRM/Test/xmlparser/testXMLParser.c
	$(WMDRM_TST_CC_CMD) $< $(CCFLAG_OUTPUT) $@